using System;
using Server;
using Server.Misc;
using Server.Items;
using Server.Spells.Spellweaving;

namespace Server.Mobiles
{
	//[CorpseName( "a forest elf corpse" )]
	public class ForestElf : BaseCreature
	{
		private DateTime m_HidingDelay = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 10, 20 ) );
		private DateTime m_NextSpeechTime = DateTime.Now;
		
		public override bool ShowFameTitle{ get{ return false; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override int TreasureMapLevel{ get{ return 2; } }
		public override bool CanRummageCorpses{ get{ return true; } }
		
		public override WeaponAbility GetWeaponAbility()
		{
			switch ( Utility.Random( 3 ) )
			{
				default:
					case 0: return WeaponAbility.Bladeweave;
					case 1: return WeaponAbility.ForceOfNature;
					case 2: return WeaponAbility.PsychicAttack;
			}
		}
		
		[Constructable]
		public ForestElf() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Hue = Race.Elf.RandomSkinHue();
			Name = NameList.RandomName( "elven" );
			
			if ( Female = Utility.RandomBool() )
			{
				Body = 606;
			}
			else
			{
				Body = 605;
			}
			// hair, facial hair
			HairItemID = Race.Elf.RandomHair( Female );
			HairHue = Race.Elf.RandomHairHue();
			Race = Race.Elf;
			Title = "the forest elf";
			
			SetStr( 206, 300 );
			SetDex( 90, 105 );
			SetInt( 61, 75 );

			SetDamage( 15, 27 );
			SetHits( 351, 475 );
			SetMana( 1450, 1500 );
			
			// 			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 25, 50 );
			SetResistance( ResistanceType.Fire, 25, 50 );
			SetResistance( ResistanceType.Cold, 25, 50 );
			SetResistance( ResistanceType.Poison, 25, 50 );
			SetResistance( ResistanceType.Energy, 25, 30 );

			SetSkill( SkillName.SpiritSpeak, 80.0, 100.0 );
			SetSkill( SkillName.MagicResist, 80.0, 110.0 );
			SetSkill( SkillName.Swords, 80.0, 110.0 );
			SetSkill( SkillName.Fencing, 80.0, 110.0 );
			SetSkill( SkillName.Macing, 80.0, 110.0 );
			SetSkill( SkillName.Tactics, 80.0, 110.0 );
			SetSkill( SkillName.Wrestling, 80.0, 110.0 );
			SetSkill( SkillName.Anatomy, 80.0, 110.0 );
			SetSkill( SkillName.ArmsLore, 80.0, 110.0 );
			SetSkill( SkillName.Parry, 60.0, 90.0 );
			SetSkill( SkillName.Hiding, 100.1 );
			SetSkill( SkillName.DetectHidden, 100.1, 120.0 );
			SetSkill( SkillName.Stealth, 300.0 );
			SetSkill( SkillName.AnimalTaming, 120.0 );
			SetSkill( SkillName.AnimalLore, 120.0 );
			SetSkill( SkillName.Spellweaving, 90.1, 120.0 );
			
			// outfit
			BaseArmor arms = new HidePauldrons();
			//          arms.Resource = CraftResource.BarbedLeather;
			arms.Movable= false;
			AddItem( arms );
			if ( this.Female )
			{
				BaseArmor femalechest = new HideFemaleChest();
				//          femalechest.Resource = CraftResource.BarbedLeather;
				femalechest.Movable= false;
				AddItem( femalechest );
			}
			else
			{
				BaseArmor chest = new HideChest();
				//          chest.Resource = CraftResource.BarbedLeather;
				chest.Movable= false;
				AddItem( chest );
			}
			BaseArmor gloves = new HideGloves();
			//          gloves.Resource = CraftResource.BarbedLeather;
			gloves.Movable= false;
			AddItem( gloves );
			BaseArmor gorget = new HideGorget();
			//          gorget.Resource = CraftResource.BarbedLeather;
			gorget.Movable= false;
			AddItem( gorget );
			BaseArmor legs = new HidePants();
			//          legs.Resource = CraftResource.BarbedLeather;
			legs.Movable= false;
			AddItem( legs );
			if ( Utility.RandomDouble() < 0.3 )
			{
				Item cloak = new Cloak();
				cloak.Hue = Utility.RandomNeutralHue();
				AddItem( cloak );
			}
			if ( Utility.RandomDouble() < 0.1 )
			{
				if ( this.Female )
				{
					Item femalerobe = new FemaleElvenRobe();
					if (Utility.RandomDouble() < 0.3)
						femalerobe.Hue = Utility.RandomNeutralHue();
					femalerobe.Movable = ( Utility.RandomDouble() < 0.005 ) ? true : false;
					AddItem( femalerobe );
				}
				else
				{
					Item robe = new MaleElvenRobe();;
					if (Utility.RandomDouble() < 0.3)
						robe.Hue = Utility.RandomNeutralHue();
					robe.Movable = ( Utility.RandomDouble() < 0.005 ) ? true : false;
					AddItem( robe );
				}
			}
			if ( Utility.RandomBool() )
			{
				Item belt = new WoodlandBelt();
				belt.Movable= false;
				AddItem( belt );
			}
			Item boots = new ElvenBoots();
			boots.Movable= false;
			AddItem( boots );
			//talismany
			if ( Utility.RandomDouble() < 0.002 )
			{
				Item wisdomofancientforest = new WisdomOfAncientForest();
				AddItem( wisdomofancientforest );
			}
			else
			{
				Item talisman = new RandomTalisman();
				talisman.Movable = ( Utility.RandomDouble() < 0.005 ) ? true : false;
				AddItem( talisman );
			}

			switch ( Utility.Random( 5 ) )
			{
				case 0:
					{
						BaseArmor ravenhelm = new RavenHelm();
						//                ravenhelm.Resource = CraftResource.Obsidian;
						ravenhelm.Movable = false;
						AddItem( ravenhelm );
					}
					break;
				case 1:
					{
						BaseArmor royalcirclet = new RoyalCirclet();
						//                royalcirclet.Resource = CraftResource.Obsidian;
						royalcirclet.Movable = false;
						AddItem( royalcirclet );
					}
					break;
				case 2:
					{
						BaseArmor vulturehelm = new VultureHelm();
						//                vulturehelm.Resource = CraftResource.Obsidian;
						vulturehelm.Movable = false;
						AddItem( vulturehelm );
					}
					break;
				case 3:
					{
						BaseArmor wingedhelm = new WingedHelm();
						//                wingedhelm.Resource = CraftResource.Obsidian;
						wingedhelm.Movable = false;
						AddItem( wingedhelm );
					}
					break;
				case 4:
					{
						BaseArmor gemmedcirclet = new GemmedCirclet();
						//                gemmedcirclet.Resource = CraftResource.Obsidian;
						gemmedcirclet.Movable = false;
						AddItem( gemmedcirclet );
					}
					break;
			}

			switch ( Utility.Random( 2 ) )
			{
				case 0:
					switch ( Utility.Random( 5 ))
					{
						case 0:
							{
								BaseWeapon spear = new Spear();
								if ( Utility.RandomBool() )
									spear.Resource = CraftResource.Verite;
								spear.Movable = false;
								AddItem( spear );
							}
							break;
						case 1:
							{
								BaseWeapon elvenspellblade = new ElvenSpellblade();
								if ( Utility.RandomBool() )
									elvenspellblade.Resource = CraftResource.Verite;
								elvenspellblade.Movable = false;
								AddItem( elvenspellblade );
							}
							break;
						case 2:
							{
								BaseWeapon ornateaxe = new OrnateAxe();
								if ( Utility.RandomBool() )
									ornateaxe.Resource = CraftResource.Verite;
								ornateaxe.Movable = false;
								AddItem( ornateaxe );
							}
							break;
						case 3:
							{
								BaseWeapon runeblade = new RuneBlade();
								if ( Utility.RandomBool() )
									runeblade.Resource = CraftResource.Verite;
								runeblade.Movable = false;
								AddItem( runeblade );
							}
							break;
						case 4:
							{
								BaseWeapon wildstaff = new WildStaff();
								if ( Utility.RandomBool() )
									wildstaff.Resource = CraftResource.Ash;
								wildstaff.Movable = false;
								AddItem( wildstaff );
							}
							break;
					}
					break;
				case 1:
					switch ( Utility.Random( 6 ))
					{
						case 0:
							{
								BaseWeapon assassinspike = new AssassinSpike();
								if ( Utility.RandomBool() )
									assassinspike.Resource = CraftResource.Verite;
								assassinspike.Movable = false;
								AddItem( assassinspike );
							}
							break;
						case 1:
							{
								BaseWeapon diamondmace = new DiamondMace();
								if ( Utility.RandomBool() )
									diamondmace.Resource = CraftResource.Verite;
								diamondmace.Movable = false;
								AddItem( diamondmace );
							}
							break;
						case 2:
							{
								BaseWeapon elvenmachete = new ElvenMachete();
								if ( Utility.RandomBool() )
									elvenmachete.Resource = CraftResource.Verite;
								elvenmachete.Movable = false;
								AddItem( elvenmachete );
							}
							break;
						case 3:
							{
								BaseWeapon leafblade = new Leafblade();
								if ( Utility.RandomBool() )
									leafblade.Resource = CraftResource.Verite;
								leafblade.Movable = false;
								AddItem( leafblade );
							}
							break;
						case 4:
							{
								BaseWeapon radiantscimitar = new RadiantScimitar();
								if ( Utility.RandomBool() )
									radiantscimitar.Resource = CraftResource.Verite;
								radiantscimitar.Movable = false;
								AddItem( radiantscimitar );
							}
							break;
						case 5:
							{
								BaseWeapon warcleaver = new WarCleaver();
								if ( Utility.RandomBool() )
									warcleaver.Resource = CraftResource.Verite;
								warcleaver.Movable = false;
								AddItem( warcleaver );
							}
							break;
					}
					switch ( Utility.Random( 2 ))
					{
						case 0:
							{
								BaseShield bronzeshield = new BronzeShield();
								if ( Utility.RandomBool() )
									bronzeshield.Resource = CraftResource.Verite;
								bronzeshield.Movable= false;
								AddItem( bronzeshield );
							}
							break;
						case 1:
							{
								BaseShield woodenshield = new WoodenShield();
								if ( Utility.RandomBool() )
									woodenshield.Resource = CraftResource.Ash;
								woodenshield.Movable= false;
								AddItem( woodenshield );
							}
							break;
					}
					break;
			}
			//end outfit
			
			PackItem( new Bandage( Utility.RandomMinMax( 5, 15 ) ) );
			// 			PackGold( 100, 200 );

			Fame = 5000;
			Karma = -7000;
			VirtualArmor = 0;
			
			if ( Utility.RandomDouble() < 0.1 )
			{
				if ( Utility.RandomBool() )
					new CuSidhe().Rider = this;
				else
					new Reptalon().Rider = this;
			}
			
			// if ( Utility.RandomDouble() < 0.0055 )
			// {
				// switch ( Utility.Random( 5 ))
				// {
					// case 0: PackItem( new RangerArms() ); break;
					// case 1: PackItem( new RangerGloves() ); break;
					// case 2: PackItem( new RangerGorget() ); break;
					// case 3: PackItem( new RangerChest() ); break;
					// case 4: PackItem( new RangerLegs() ); break;
				// }
			// }
		}
		
		// 		public override void OnDeath( Container c )
		// 		{
		// 			base.OnDeath( c );

		// 			if ( Utility.RandomDouble() < 0.05 )
		//             c.DropItem( new ForestElvesAmulet() );
		// 		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.Rich );
		}
		
		public override bool IsNotScaredOfDeath{ get{ return Utility.RandomBool(); } } //neutika pri malem poctu hp - sance 50%
		
		public override void OnThink()
		{
			m_HidingDelay = Ability.HideSelf( this, m_HidingDelay, Utility.RandomMinMax( 10, 15 ), 5 );
			// 			base.OnThink();
		}

		public override void OnMovement( Mobile m, Point3D oldLocation )
		{
			if ( !this.Hidden && this.Frozen && this.Combatant != null )
			{
				this.Frozen = false;
			}
			
			if ( !this.Hidden && DateTime.Now > m_NextSpeechTime && m.InRange( this, 3 ) && m is PlayerMobile )
			{
				m_NextSpeechTime = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 10, 20 ) );
				SayRandom( DarkElf.ElfSay, this );
				this.Move( GetDirectionTo( m.Location ) );
			}
		}
		
		public override bool OnBeforeDeath()
		{
			IMount mount = this.Mount;
			if   ( mount != null )
				mount.Rider = null;
			
			if ( mount is Mobile )
			{
				if ( Utility.RandomDouble() < 0.95 || this.Map == Map.Underworld )
					((Mobile)mount).Delete();
				else
					((Mobile)mount).Combatant = this.Combatant;
			}
			
			return base.OnBeforeDeath();
		}
		
		private static void SayRandom( string[] say, Mobile m )
		{
			m.Say( say[Utility.Random( say.Length )] );
		}
		
		public override void OnActionCombat()
		{
			if ( this.Combatant != null && Utility.RandomDouble() < 0.025 )
			{
				switch ( Utility.Random( 3 ) )
				{
					case 0:
						{
							if ( !this.Mounted )
								new ReaperFormSpell( this, null ).Cast();
						}
						break;
					case 1:
						{
							new AttunementSpell( this, null ).Cast();
						}
						break;
					case 2:
						{
							new ImmolatingWeaponSpell( this, null ).Cast();
						}
						break;
						//                case 3:
						//                {
						//                   new GiftOfRenewalSpell( this, null ).Cast();
//
						//                   if ( this.Target != null )
						//                      this.Target.Invoke( this, this );
						//                }
						//                break;
				}
			}
			base.OnActionCombat();
		}
		
		public ForestElf( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}
